package com.aps.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 工序可用设备
 * </p>
 *
 * @author MyBatis-Plus
 * @since 2025-10-10
 */
@Getter
@Setter
@TableName("routing_detail_equip")
public class RoutingDetailEquip implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 创建时间
     */
    private LocalDateTime creationtime;

    /**
     * 创建人
     */
    private Integer creatoruserid;

    /**
     * 更新时间
     */
    private LocalDateTime lastmodificationtime;

    /**
     * 更新人
     */
    private Long lastmodifieruserid;

    /**
     * 删除人
     */
    private Integer isdeleted;

    /**
     * 删除时间
     */
    private LocalDateTime deletiontime;

    /**
     * 删除人
     */
    private Integer deleteruserid;

    /**
     * 设备类型
     */
    private Long type1;

    /**
     * 设备类型名
     */
    private String typeName;

    /**
     * 设备名称
     */
    private String name;

    /**
     * 产出数量
     */
    private BigDecimal outputQuantity;

    /**
     * 计量单位
     */
    private Integer measureUnit;

    /**
     * 计量单位名称
     */
    private String measureUnitName;

    /**
     * 持续时间
     */
    private BigDecimal duration;

    private String exp1;

    private String exp2;

    /**
     * 设备的类型：1--设备  2--班组
     */
    private Integer exp3;

    private Integer exp4;

    /**
     * 工序id
     */
    private Long routingDetailId;

    /**
     * 设备id
     */
    private Long equipId;

    /**
     * 工艺id
     */
    private Long routingHeaderId;

    /**
     * 单次批量产出
     */
    private BigDecimal oneBatchQuantity;

    private String strId;
}