package com.aps.entity.Algorithm;

import com.aps.entity.basic.Entry;
import com.aps.entity.basic.Machine;
import com.aps.entity.basic.Order;
import lombok.Data;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * 作者：佟礼
 * 时间：2025-11-21
 */
@Data
public class Chromosome {

    private String ID = UUID.randomUUID().toString();

    /// <summary>
    /// 机器选择部分（可选机器集中的顺序号）
    /// </summary>
    private List<Integer> MachineSelection;

    /// <summary>
    /// 工序排序部分（工件/订单ID）
    /// </summary>
    private String MachineStr;

    public String getMachineStr() {
        if(MachineSelection==null) return "";
        return MachineSelection.stream()
                .map(String::valueOf) // 将每个 Integer 转换为 String
                .collect(Collectors.joining(","));
    };

    /// <summary>
    /// 工序排序部分（工件/订单ID）
    /// </summary>
    private List<Integer> OperationSequencing;

    /// <summary>
    /// 工序排序部分（工件/订单ID）
    /// </summary>
    private String OperationStr;

    public String getOperationStr() {
        if(OperationSequencing==null) return "";
        return OperationSequencing.stream()
                .map(String::valueOf) // 将每个 Integer 转换为 String
                .collect(Collectors.joining("|"));
    };

    private  List<GlobalOperationInfo> globalOpList;
    private  List<Entry> allOperations;
    private  List<Order> orders;
    private  List<Machine> InitMachines;
    /// <summary>
    /// 适应度值
    /// </summary>
    private double Fitness;

    /// <summary>
    /// 机器
    /// </summary>
    private List<Machine> Machines;

    /// <summary>
    /// 解码后的调度结果
    /// </summary>
    private List<GAScheduleResult> Result;

    /// <summary>
    /// 最早完工时间
    /// </summary>
    private double Makespan;

    /// <summary>
    /// 总流程时间
    /// </summary>
    private double TotalFlowTime;

    /// <summary>
    /// 总换型时间
    /// </summary>
    private double TotalChangeoverTime;

    /// <summary>
    /// 机器负载标准差（越小越均衡）
    /// </summary>
    private double MachineLoadStd;

    /// <summary>
    /// 交付期延迟时间
    /// </summary>
    private double DelayTime;


}
