package com.aps.service.Algorithm;

import com.aps.common.util.DeepCopyUtil;
import com.aps.common.util.ProductionDeepCopyUtil;
import com.aps.entity.Algorithm.Chromosome;
import com.aps.entity.Algorithm.GlobalOperationInfo;
import com.aps.entity.Algorithm.Pair;
import com.aps.entity.Algorithm.ScheduleParams;
import com.aps.entity.basic.*;
import com.aps.service.plan.MachineSchedulerService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 作者：佟礼
 * 时间：2025-11-21
 */
public class GeneticAlgorithm {
    private final Random rnd = new Random();
    private final List<Machine> machines;
    private final MachineSchedulerService machineScheduler;
    private final List<Order> orders;
    private final List<Material> materials;
    private static GlobalParam _GlobalParam;

    public GeneticAlgorithm(GlobalParam globalParam,List<Machine> machines, List<Order> orders,
                                List<Material> materials, MachineSchedulerService machineScheduler) {
        this.machines = machines;
        this.orders = orders;
        this.materials = materials;
        this.machineScheduler = machineScheduler;
        _GlobalParam=globalParam;
    }
    public Chromosome Run(ScheduleParams param, List<Entry> allOperations) {
        System.out.println("开始");

        Initialization initialization = new Initialization(_GlobalParam,allOperations);

        GeneticOperations geneticOps = new GeneticOperations(_GlobalParam,allOperations);

        // 预生成全局工序列表（所有初始化方法共享同一顺序）
        List<GlobalOperationInfo> globalOpList = initialization.generateGlobalOpList();

        // 步骤1：初始化种群
        List<Chromosome> population = initialization.generateInitialPopulation(param, globalOpList);

        Chromosomedecode(param,allOperations,globalOpList,population);

        int ordercount = globalOpList.stream()
                .mapToInt(GlobalOperationInfo::getGroupId)
                .max()
                .orElse(0);
        Chromosome best=new Chromosome();
        best=  population.stream()
                .max(Comparator.comparingDouble(Chromosome::getFitness))
                .orElse(null);
        double bestFitness=0;
        int Iteration=0;
        // 步骤2：迭代进化
        for (int iter = 0; iter < param.getMaxIterations(); iter++) {
            // 解码并计算适应度


            // 检查终止条件（此处简化为迭代次数）
            if (iter == param.getMaxIterations() - 1) {
                break;
            }

            // 选择操作
            List<Chromosome> selected = geneticOps.tournamentSelection(population);

            // 交叉操作
            List<Chromosome> nextPopulation = new ArrayList<>();
            for (int i = 0; i < selected.size(); i += 2) {
                if (i + 1 >= selected.size()) {
                    nextPopulation.add(selected.get(i));
                    break;
                }

                Chromosome parent1 = selected.get(i);
                Chromosome parent2 = selected.get(i + 1);
                if (rnd.nextDouble() < param.getCrossoverProb()) {
                    // 假设PoxCrossover返回包含两个子染色体的数组
                    Pair<Chromosome, Chromosome> children = geneticOps.poxCrossover(parent1, parent2, ordercount);
                    nextPopulation.add(children.getFirst());
                    nextPopulation.add(children.getSecond());
                } else {
                    nextPopulation.add(parent1);
                    nextPopulation.add(parent2);
                }
            }

            // 变异操作
            for (Chromosome chromosome : nextPopulation) {
                if (rnd.nextDouble() < param.getMutationProb()) {
                    geneticOps.mutate(chromosome, globalOpList);
                }
            }

            // 精英保留
            List<Chromosome> population1 = population.stream()
                    .sorted((c1, c2) -> Double.compare(c2.getFitness(), c1.getFitness()))
                    .collect(Collectors.toList()); // 降序排序


            List<Chromosome>   elites = population1.subList(0, param.getElitismCount());

            List<Chromosome> newPopulation = new ArrayList<>();
            newPopulation.addAll(elites);
            newPopulation.addAll(nextPopulation);

            // 更新种群
            population = newPopulation.stream()
                    .limit(param.getPopulationSize() )
                    .collect(Collectors.toList());

            Chromosomedecode(param,allOperations,globalOpList,population);
            best=  population.stream()
                    .max(Comparator.comparingDouble(Chromosome::getFitness))
                    .orElse(null);
            if(bestFitness<best.getFitness())
            {
                bestFitness=best.getFitness();
            }else {

                Iteration++;
            }
            if(Iteration>10)
            {
                break;
            }
        }
        best.setBaseTime(param.getBaseTime());
        best.setInitMachines(ProductionDeepCopyUtil.deepCopyList(machines));
        best.setOrders(orders);
        // 步骤3：返回最优解
        return best;

    }
    private  void  Chromosomedecode(ScheduleParams param, List<Entry> allOperations,List<GlobalOperationInfo> globalOpList,List<Chromosome> population)
    {
        GeneticDecoder decoder = new GeneticDecoder(_GlobalParam, param.getBaseTime(), machines, orders, materials, machineScheduler);
        FitnessCalculator fitnessCalc = new FitnessCalculator();

//        population.parallelStream().forEach(chromosome -> {
//            chromosome.setResult(new ArrayList<>());
//
//            // 假设Machine类有拷贝方法，或使用MapStruct等工具进行映射
//            chromosome.setMachines(ProductionDeepCopyUtil.deepCopyList(machines)); // 简单拷贝，实际可能需要深拷贝
//
//            decoder.decodeChromosomeWithCache(chromosome, globalOpList, allOperations);
//            chromosome.setFitness(fitnessCalc.calculateFitness(chromosome));
//        });
        if(population!=null&&population.size()>0) {
            population.forEach(chromosome -> {
                chromosome.setResult(new ArrayList<>());

                // 假设Machine类有拷贝方法，或使用MapStruct等工具进行映射
                chromosome.setMachines(ProductionDeepCopyUtil.deepCopyList(machines)); // 简单拷贝，实际可能需要深拷贝
                chromosome.setAllOperations(allOperations); // 简单拷贝，实际可能需要深拷贝
                chromosome.setGlobalOpList(globalOpList); // 简单拷贝，实际可能需要深拷贝

                Chromosome chromosomen = decoder.decodeChromosomeWithCache(chromosome);
                if (chromosomen.getFitness() == 0) {
                    chromosomen.setFitness(fitnessCalc.calculateFitness(chromosomen));
                }
            });
        }
    }

}
