package com.aps.entity.Gantt;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Schema(name = "产品甘特图数据模型", description = "产品甘特图数据模型")
public class ProductGanttVO {

    @Schema(description = "产品ID")
    private Integer id;

    @Schema(description = "产品名称")
    private String productName;

    @Schema(description = "产品类型")
    private Integer productType;

    @Schema(description = "产品编号")
    private Integer productId;

    @Schema(description = "数量")
    private Integer quantity;

    @Schema(description = "编码")
    private String code;

    @Schema(description = "开始日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private LocalDateTime startDate;

    @Schema(description = "结束日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private LocalDateTime endDate;

    @Schema(description = "车间ID")
    private Integer shopId;

    @Schema(description = "车间名称")
    private String shopName;

    @Schema(description = "状态")
    private String status;

    @Schema(description = "头ID")
    private Integer headerId;

    @Schema(description = "头名称")
    private String headerName;

    @Schema(description = "任务列表")
    private List<TaskVO> list;
}