package com.aps.entity.common;

public enum ConditionEnum {

    Equal("Equal",0), // 等于
    NoEqual("NoEqual",10), // 等于
    Like("Like",1), //模糊
    GreaterThan("GreaterThan",2), //大于
    GreaterThanOrEqual("GreaterThanOrEqual",3), //大于等于
    LessThan("LessThan",4), //小于
    LessThanOrEqual("LessThanOrEqual",5), //小于等于
    In("In",6),   //包含
    NotIn("NotIn",7),
    Between("Between",8),  //范围查找
    Keys("Keys",9),  //字段 或 连接
    InSql("InSql",10) // 工单执行，应用在根据派工人查询工单
    ,
    IsEmpty("IsEmpty",11) ,// 是null 或者 ""
    NotEmpty("NotEmpty",12),//不是 null 也不是""
    Exists("Exists",13),
    NotExists("NotExists",14),
    InSet("InSet",15);
    private String name;
    private Integer value;

    ConditionEnum(String name, Integer value) {
        this.name=name;
        this.value=value;
    }

    public static ConditionEnum getByName(String name) {
        for (ConditionEnum status : ConditionEnum.values()) {
            if (status.getName().equalsIgnoreCase(name)) {
                return status;
            }
        }
        return null;
    }


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }
}
