package com.aps.entity.basic;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Set;

public class Shift {
    private LocalTime startTime;
    private LocalTime endTime;
    private Set<Integer> days; // 改为Integer类型，便于JSON反序列化
    private LocalDateTime shiftDate;
    private boolean isTemporaryShift;
    private int priority;

    public Shift() {}


    public LocalTime getStartTime() {
        return startTime;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    public LocalTime getEndTime() {
        return endTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    public Set<Integer> getDays() {
        return days;
    }

    public void setDays(Set<Integer> days) {
        this.days = days;
    }

    // 辅助方法：将数字转换为DayOfWeek
    public Set<DayOfWeek> getDaysAsEnum() {
        if (days == null) return null;
        return days.stream()
                .map(day -> DayOfWeek.of(day == 0 ? 7 : day)) // 处理周日(0)转换为7
                .collect(java.util.stream.Collectors.toSet());
    }

    public LocalDateTime getShiftDate() {
        return shiftDate;
    }

    public void setShiftDate(LocalDateTime shiftDate) {
        this.shiftDate = shiftDate;
    }

    public boolean isTemporaryShift() {
        return isTemporaryShift;
    }

    public void setTemporaryShift(boolean temporaryShift) {
        isTemporaryShift = temporaryShift;
    }

    public int getPriority() {
        return priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }
}