package com.aps.entity.basic;

import java.time.LocalDateTime;
import java.util.Objects;

public class MaintenanceWindow {
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private String reason;
    
    public MaintenanceWindow() {}
    
    public MaintenanceWindow(LocalDateTime startTime, LocalDateTime endTime, String reason) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.reason = reason;
    }
    
    // Getters and Setters
    public LocalDateTime getStartTime() {
        return startTime;
    }
    
    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }
    
    public LocalDateTime getEndTime() {
        return endTime;
    }
    
    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }
    
    public String getReason() {
        return reason;
    }
    
    public void setReason(String reason) {
        this.reason = reason;
    }
    
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MaintenanceWindow that = (MaintenanceWindow) o;
        return Objects.equals(startTime, that.startTime) && 
               Objects.equals(endTime, that.endTime);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(startTime, endTime);
    }
}