package com.aps.common.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Scanner;

public class JsonFileReader {
    
    public static <T> List<T> readListFromResources(String fileName, Class<T> clazz) throws IOException {
        // 1. 从classpath读取文件
        try (InputStream inputStream = JsonFileReader.class.getClassLoader().getResourceAsStream(fileName)) {
            if (inputStream == null) {
                throw new IOException("File not found in resources: " + fileName);
            }
            
            // 使用Scanner替代readAllBytes以兼容Java 8
            Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8.name()).useDelimiter("\\A");
            String jsonContent = scanner.hasNext() ? scanner.next() : "";
            
            // 2. 配置ObjectMapper支持Java 8时间API
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.registerModule(new JavaTimeModule());
            objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            
            // 3. 反序列化JSON到对象列表
            return objectMapper.readValue(jsonContent,
                objectMapper.getTypeFactory().constructCollectionType(List.class, clazz));
        }
    }
}