package com.aps.service.plan;

import com.aps.common.util.FileHelper;
import com.aps.common.util.JsonFileReader;
import com.aps.common.util.ProductionDeepCopyUtil;
import com.aps.controller.gantt.FileUploadController;
import com.aps.entity.*;
import com.aps.entity.Algorithm.*;
import com.aps.entity.Algorithm.IDAndChildID.GroupResult;
import com.aps.entity.Algorithm.IDAndChildID.NodeInfo;
import com.aps.entity.basic.ScheduleChromosome;
import com.aps.entity.Schedule.GenVO;
import com.aps.entity.Schedule.MachineVO;
import com.aps.entity.basic.*;
import com.aps.service.*;
import com.aps.service.Algorithm.GeneticAlgorithm;
import com.aps.service.Algorithm.IdGroupingWithDualSerial;
import com.aps.service.Algorithm.ScheduleOperationService;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@Service
public class PlanResultService {
    // 注入FileUploadController
    @Autowired
    private FileUploadController fileUploadController;

    @Autowired
    private MesHolidayService _MesHolidayService;

    @Autowired
    private ProdEquipSpecialCalService _prodEquipSpecialCalService;

    @Autowired
    private MesShiftWorkSchedService _MesShiftWorkSchedService;


    @Autowired
    private ProdLaunchOrderService _prodLaunchOrderService;

    @Autowired
    private ProdProcessExecService _prodProcessExecService;

    @Autowired
    private ProdEquipmentService _prodEquipmentService;

    @Autowired
    private PlanResourceService _PlanResourceService;

    @Autowired
    private SceneService _sceneService;

    @Autowired
    private ProdOrderProcessService _prodOrderProcessService;

    private  LocalDateTime baseTime = LocalDateTime.of(2025, 11, 1, 0, 0, 0);

    public List<ScheduleChromosome> execute() {
        try {
            // 1. 读取数据
            List<Machine> machines = loadData("machines.json", Machine.class);
            List<Product> products = loadData("products.json", Product.class);
            List<Order> orders = loadData("orders.json", Order.class);
            
            // 设置机器信息到班次中
            for (Machine machine : machines) {
                if (machine.getShifts() != null) {
                    for (Shift shift : machine.getShifts()) {
                        shift.setMachineId(machine.getId());
                        shift.setMachineName(machine.getName());
                    }
                }
                
                // 调试：打印机器和班次信息
                System.out.println("Machine: " + machine.getId() + ", Name: " + machine.getName());
                if (machine.getShifts() != null) {
                    for (Shift shift : machine.getShifts()) {
                        System.out.println("  Shift: " + shift.getStartTime() + " - " + shift.getEndTime() + 
                                         ", Status: " + shift.getStatus() +
                                         ", MachineId: " + shift.getMachineId() +
                                         ", MachineName: " + shift.getMachineName());
                    }
                }
            }
            
            // 创建节假日
            List<Holiday> holidays = Arrays.asList(
                    new Holiday(LocalDateTime.of(2025, 10, 1, 0, 0),
                            LocalDateTime.of(2025, 10, 7, 23, 59))
            );
            
            // 将节假日添加到所有设备中
            addHolidaysToAllMachines(machines, holidays);

            // 3. 创建调度服务
            MachineSchedulerService machineScheduler = new MachineSchedulerService(
                    holidays, LocalDateTime.of(2025, 10, 1, 0, 0, 0));

            // 4. 初始化机器时间线
            for (Machine machine : machines) {
                MachineTimeline timeline = machineScheduler.getOrCreateTimeline(machine);
                machine.setAvailability(timeline.getSegments());
            }

            // 5. 执行调度算法
            AlgorithmScheduler7 scheduler = new AlgorithmScheduler7(products, machines, orders, machineScheduler);
            List<ScheduleChromosome> scheduleChromosomes = scheduler.RunAll();
            
            // 对调度结果按照 fitness 由高到低排序
            scheduleChromosomes.sort((c1, c2) -> Double.compare(c2.getFitness(), c1.getFitness()));
            
            // 为每个 ScheduleChromosome 分配场景ID（基于排序后的位置）
            for (int i = 0; i < scheduleChromosomes.size(); i++) {
                scheduleChromosomes.get(i).setSceneId(i + 1); // 场景ID从1开始
            }

            return scheduleChromosomes;

        } catch (Exception e) {
            throw new RuntimeException("调度执行失败", e);
        }
    }



       public Chromosome  execute1() {
        try {

//List<ScheduleResultDetail>  details=new ArrayList<>();
//            ScheduleResultDetail detail1=new ScheduleResultDetail();
//
//            detail1.setOneTime(100);//单件工时
//
//
//            ScheduleResultDetail detail2=new ScheduleResultDetail();
//
//            detail2.setOneTime(200);//单件工时
//            details.add(detail1);
//            details.add(detail2);


          //  mergeSegmentsWithDifferentOneTime(details, 50);
            // 1. 读取数据
            List<Machine> machines = loadData("machines.json", Machine.class);
            List<Product> products = loadData("products.json", Product.class);
            List<Order> orders = loadData("orders.json", Order.class);

            // 设置机器信息到班次中
            for (Machine machine : machines) {
                if (machine.getShifts() != null) {
                    for (Shift shift : machine.getShifts()) {
                        shift.setMachineId(machine.getId());
                        shift.setMachineName(machine.getName());
                    }
                }

                // 调试：打印机器和班次信息
                System.out.println("Machine: " + machine.getId() + ", Name: " + machine.getName());
                if (machine.getShifts() != null) {
                    for (Shift shift : machine.getShifts()) {
                        System.out.println("  Shift: " + shift.getStartTime() + " - " + shift.getEndTime() +
                                ", Status: " + shift.getStatus() +
                                ", MachineId: " + shift.getMachineId() +
                                ", MachineName: " + shift.getMachineName());
                    }
                }
            }
            ScheduleParams param = new ScheduleParams();
            param.setBaseTime(LocalDateTime.of(2025, 11, 1, 0, 0, 0));
            param.setPopulationSize(1);
            param.setMaxIterations(2);

            // List<MesHoliday> holidays=  _MesHolidayService.list();

            // 创建节假日


            // 将节假日添加到所有设备中
           // addHolidaysToAllMachines(machines);

            // 3. 创建调度服务
            MachineSchedulerService machineScheduler = new MachineSchedulerService(
                     param.getBaseTime());

            // 4. 初始化机器时间线
            for (Machine machine : machines) {
                MachineTimeline timeline = machineScheduler.getOrCreateTimeline(machine);
                machine.setAvailability(timeline.getSegments());
            }
            // 3. 构建订单-工序数据
            List<Entry> allOperations = new ArrayList<>();
            Random rnd = new Random(); // 注意：此处变量声明但未使用，可根据实际需求保留或移除

            int id = 1;
            for (Order order : orders) {
order.setDueDate(LocalDateTime.of(2025, 12, 1,0,0,0));
                // 假设products是一个List<Product>，根据Product的Id查找对应的产品
                Product product = products.stream()
                        .filter(p -> p.getId() == order.getProductId())
                        .findFirst()
                        .orElseThrow(() -> new IllegalArgumentException("未找到对应产品: " + order.getProductId()));

                int sequence = 1;
                for (Operation o : product.getOperations()) { // 假设Product类有getOperations()方法返回工序列表
                    Entry entry = new Entry();
                    entry.setId(id);
                   // entry.setGroupId(order.getId());
                    entry.setSequence(sequence);
                    entry.setMachineOptions(o.getMachineOptions()); // 假设Operation类有获取机器选项的方法
                    entry.setPriority(order.getPriority());
                    entry.setQuantity(order.getQuantity());
                    // entry.setMaterialRequirements(o.getMaterialRequirements()); // 假设Operation类有获取物料需求的方法

                    if (sequence != 1) {
                        OperationDependency od=new OperationDependency();
                        od.setPrevOperationId(id - 1);

                        entry.getPrevEntryIds().add(od); // 假设Entry类有getPrevEntryIds()返回List<Integer>
                    }

                    allOperations.add(entry);

                    sequence++;
                    id++;
                }
            }
            GlobalParam globalParam=new GlobalParam();
            // 5. 执行调度算法
            GeneticAlgorithm scheduler =new GeneticAlgorithm(globalParam,machines,orders,null,machineScheduler); //new GeneticAlgorithm(products, machines, orders, machineScheduler);
            Chromosome Chromosomes =scheduler.Run(param,allOperations);
            WriteScheduleSummary(Chromosomes);
            ScheduleOperationService ScheduleOperation=new ScheduleOperationService();
            LocalDateTime ds=  LocalDateTime.of(2025, 12, 7, 23, 59);
           // ScheduleOperation.moveOperation(Chromosomes,3, (int)ChronoUnit.SECONDS.between(param.getBaseTime(), ds),(Long)2,param.getBaseTime(), globalParam);
           WriteScheduleSummary(Chromosomes);

            return Chromosomes;

        } catch (Exception e) {
            throw new RuntimeException("调度执行失败", e);
        }
    }

    public Chromosome  execute2(String SceneId) {
        try {
            ScheduleParams param = new ScheduleParams();
            param.setBaseTime(LocalDateTime.of(2025, 11, 1, 0, 0, 0));
            param.setPopulationSize(50);
            param.setMaxIterations(100);


            // 1. 读取数据
            //  List<Machine> machines = loadData("machines.json", Machine.class);
            //  List<Product> products = loadData("products.json", Product.class);
            // List<Order> orders = loadData("orders.json", Order.class);




            List<ProdEquipment> ProdEquipments=  _prodEquipmentService.lambdaQuery()
                    .eq(ProdEquipment::getSceneId,SceneId)
                    .list();

            List<ProdLaunchOrder> ProdLaunchOrders=  _prodLaunchOrderService.lambdaQuery()
                    .eq(ProdLaunchOrder::getSceneId,SceneId)
                    .list();
            // 3. 创建调度服务
            MachineSchedulerService machineScheduler = new MachineSchedulerService(
                    param.getBaseTime());
            List<Machine> machines= InitCalendarToAllMachines(SceneId, ProdEquipments,machineScheduler);
            // 3. 构建订单-工序数据

            List<Order> orders=new ArrayList<>();
            for (ProdLaunchOrder lo : ProdLaunchOrders) {
                Order order=new Order();
                order.setOrderId(lo.getOrderId());
                order.setMaterialId(lo.getMaterialId());
                order.setDueDate(lo.getEndDate());
                order.setQuantity(lo.getQuantity());
                orders.add(order);
            }

            Map<Integer,Object> list= InitEntrys(SceneId,ProdEquipments,ProdLaunchOrders);
           List<Entry> entrys=(List<Entry>)list.get(1);
            List<GroupResult> entryRel=(List<GroupResult>)list.get(2);

            GlobalParam globalParam=new GlobalParam();
            // 5. 执行调度算法
            GeneticAlgorithm scheduler =new GeneticAlgorithm(globalParam,machines,orders,null,machineScheduler); //new GeneticAlgorithm(products, machines, orders, machineScheduler);
            Chromosome chromosome =scheduler.Run(param,entrys);
            chromosome.setOperatRel(entryRel);
            _sceneService.saveChromosomeToFile(chromosome, SceneId);

           // Chromosomes.forEach(this::WriteScheduleSummary);

            return chromosome;

        } catch (Exception e) {
            throw new RuntimeException("调度执行失败", e);
        }
    }

    public Chromosome  EditOperation(String SceneId,Entry operation) {
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);
        if (chromosome == null || chromosome.getAllOperations() == null) {
            return chromosome; // 直接返回，空值由上层处理
        }
        List<Entry> operations = chromosome.getAllOperations();
        // 直接查找匹配元素的索引（避免先找元素再查索引的冗余）
        int position = IntStream.range(0, operations.size())
                .filter(i -> {
                    Entry t = operations.get(i);
                    return t.getId()==operation.getId();
                })
                .findFirst()
                .orElse(-1);
        // 索引有效时替换
        if (position != -1) {
            operations.set(position, operation);
        }

        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        GlobalParam globalParam=new GlobalParam();
        ScheduleOperation.redecode(chromosome,chromosome.getBaseTime(), globalParam);

        return  chromosome;
    }

    public Chromosome  ChangeBaseTime(String SceneId,LocalDateTime BaseTime) {
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);
        if (chromosome == null || chromosome.getAllOperations() == null) {
            return chromosome; // 直接返回，空值由上层处理
        }

        chromosome.setBaseTime(BaseTime);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        GlobalParam globalParam=new GlobalParam();
        ScheduleOperation.redecode(chromosome,chromosome.getBaseTime(), globalParam);

        return  chromosome;
    }
    public Chromosome  Move(String SceneId,int opId, LocalDateTime newStartTime,
                            Long newMachineId) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);


        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.moveOperation(chromosome,opId, (int)ChronoUnit.SECONDS.between(chromosome.getBaseTime(), newStartTime),newMachineId, globalParam);
      //  WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }

    public Chromosome  SpiltOperation(String SceneId,int opId,Double[] splitCounts) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);

        //this.baseTime=param.getBaseTime();
        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.SpiltOperation(chromosome,opId,splitCounts, globalParam);
        WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }

    public Chromosome  DelOperation(String SceneId,int opId) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);

        //this.baseTime=param.getBaseTime();
        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.DelOperation(chromosome,opId, globalParam);
       // WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }

    public Chromosome  LockOperation(String SceneId,int opId,boolean isLocked) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);

        //this.baseTime=param.getBaseTime();
        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.LockOperation(chromosome,opId,isLocked, globalParam);
        //WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }

    public Chromosome  SpiltOrder(String SceneId,String orderId,Double[] splitCounts) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);

        //this.baseTime=param.getBaseTime();
        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.SpiltOrder(chromosome,orderId,splitCounts, globalParam);
        WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }
    public Chromosome  MergeOrder(String SceneId,String sourceorderId,String targetorderId) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);

        //this.baseTime=param.getBaseTime();
        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.MergeOrder(chromosome,sourceorderId,targetorderId, globalParam);
        WriteScheduleSummary(chromosome);
        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }











        public Chromosome  schedule(String SceneId) {
        try {
            ScheduleParams param = new ScheduleParams();

            param.setBaseTime(LocalDateTime.of(2025, 11, 1, 0, 0, 0));
            param.setPopulationSize(50);
            param.setMaxIterations(100);


            // 1. 读取数据
            //  List<Machine> machines = loadData("machines.json", Machine.class);
            //  List<Product> products = loadData("products.json", Product.class);
            // List<Order> orders = loadData("orders.json", Order.class);




            List<ProdEquipment> ProdEquipments=  _prodEquipmentService.lambdaQuery()
                    .eq(ProdEquipment::getSceneId,SceneId)
                    .list();

            List<ProdLaunchOrder> ProdLaunchOrders=  _prodLaunchOrderService.lambdaQuery()
                    .eq(ProdLaunchOrder::getSceneId,SceneId)
                    .list();
            // 3. 创建调度服务
            MachineSchedulerService machineScheduler = new MachineSchedulerService(
                    param.getBaseTime());
            List<Machine> machines= InitCalendarToAllMachines(SceneId, ProdEquipments,machineScheduler);
            // 3. 构建订单-工序数据

            List<Order> orders=new ArrayList<>();
            for (ProdLaunchOrder lo : ProdLaunchOrders) {
                Order order=new Order();
                order.setOrderId(lo.getOrderId());
                order.setMaterialId(lo.getMaterialId());
                order.setDueDate(lo.getEndDate());
                order.setQuantity(lo.getQuantity());
                orders.add(order);
            }


            Map<Integer,Object> list= InitEntrys(SceneId,ProdEquipments,ProdLaunchOrders);
            List<Entry> entrys=(List<Entry>)list.get(1);
            List<GroupResult> entryRel=(List<GroupResult>)list.get(2);


            GlobalParam globalParam=new GlobalParam();
            // 5. 执行调度算法
            GeneticAlgorithm scheduler =new GeneticAlgorithm(globalParam,machines,orders,null,machineScheduler); //new GeneticAlgorithm(products, machines, orders, machineScheduler);
            Chromosome  chromosomes =scheduler.Run(param,entrys);

            chromosomes.setScenarioID(SceneId);
            chromosomes.setBaseTime(param.getBaseTime());
            chromosomes.setOperatRel(entryRel);
            // 保存chromosomes到文件
            _sceneService.saveChromosomeToFile(chromosomes, SceneId);

            // Chromosomes.forEach(this::WriteScheduleSummary);

            return chromosomes;

        } catch (Exception e) {
            throw new RuntimeException("调度执行失败", e);
        }
    }


    public void WriteScheduleSummary(Chromosome schedule) {
        // 写入日志
        FileHelper.writeLogFile(String.format("\n=== Schedule Summary === %f", schedule.getFitness()));
        FileHelper.writeLogFile(String.format("Operation: %s", schedule.getOperationStr()));
        FileHelper.writeLogFile(String.format("Makespan: %f minutes", schedule.getMakespan()));
        FileHelper.writeLogFile(String.format("Total Tardiness: %f hours", schedule.getDelayTime()));
        FileHelper.writeLogFile(String.format("Setup Time: %f minutes", schedule.getTotalChangeoverTime()));
        FileHelper.writeLogFile(String.format("Flow Time: %f minutes", schedule.getTotalFlowTime()));
        FileHelper.writeLogFile(String.format("Machine Load Balance: %.2f%%", schedule.getMachineLoadStd() * 100));
        FileHelper.writeLogFile("-------------------------");

        // 按订单分组写入
        Map<Integer, List<GAScheduleResult>> orderGroups = schedule.getResult().stream()
                .collect(Collectors.groupingBy(GAScheduleResult::getGroupId));

        for (Map.Entry<Integer, List<GAScheduleResult>> group : orderGroups.entrySet()) {
            List<GAScheduleResult> sortedJobs = group.getValue().stream()
                    .sorted(Comparator.comparingInt(GAScheduleResult::getOperationId))
                    .collect(Collectors.toList());

            for (GAScheduleResult job : sortedJobs) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(String.format(
                            "[%d-%d]:[%s-%s] Order %d,  Machine %d, Operation %d, Batch %.1f, processingTime %%.1f",
                            job.getStartTime(),
                            job.getEndTime(),
                            ConvertTime(job.getStartTime()),
                            ConvertTime(job.getEndTime()),
                            job.getGroupId(),

                            job.getMachineId(),
                            job.getOperationId(),
                            job.getQuantity(),
                            job.getProcessingTime()
                    ));

                    // 追加基因详情
                    for (ScheduleResultDetail d : job.getGeneDetails()) {
                        sb.append(String.format(
                                "\n\t\t\t\t\t\t\t\t\t\t [%d-%d]:[%s-%s] %d",
                                d.getStartTime(),
                                d.getEndTime(),
                                ConvertTime(d.getStartTime()),
                                ConvertTime(d.getEndTime()),
                                d.getEndTime() - d.getStartTime()
                        ));
                    }

                    FileHelper.writeLogFile(sb.toString());

            }
            FileHelper.writeLogFile("");
        }
    }
    private String ConvertTime(int minute) {
        return baseTime.plusSeconds(minute).format(java.time.format.DateTimeFormatter.ofPattern("MM-dd HH:mm"));
    }

    /**
     * 加载数据，优先从上传文件夹加载，如果不存在则从resources加载
     *
     * @param fileName 文件名
     * @param clazz    类型
     * @param <T>      泛型
     * @return 数据列表
     * @throws IOException IO异常
     */
    private <T> List<T> loadData(String fileName, Class<T> clazz) throws IOException {
        // 检查是否有上传的文件
        if (fileUploadController.isFileUploaded(fileName)) {
            String filePath = fileUploadController.getUploadedFilePath(fileName);
            return JsonFileReader.readListFromFile(filePath, clazz);
        } else {
            // 使用默认的resources文件
            return JsonFileReader.readListFromResources(fileName, clazz);
        }
    }
    
    /**
     * 将假期添加到所有设备的维护窗口中
     * @param machines 设备列表
     * @param holidays 假期列表
     */
    private void addHolidaysToAllMachines(List<Machine> machines, List<Holiday> holidays) {
        if (machines == null || holidays == null) {
            return;
        }
        
        for (Machine machine : machines) {
            // 确保维护窗口列表不为null
            if (machine.getMaintenanceWindows() == null) {
                machine.setMaintenanceWindows(new ArrayList<>());
            }
            
            for (Holiday holiday : holidays) {
                // 将假期转换为维护窗口并添加到设备中
                MaintenanceWindow maintenanceWindow = new MaintenanceWindow(holiday, "Holiday Period");
                machine.addMaintenanceWindow(maintenanceWindow);
            }
        }
    }

    private List<Machine> InitCalendarToAllMachines(String SceneId,List<ProdEquipment> ProdEquipments,MachineSchedulerService machineScheduler) {
        // 按设备分组

        List<Long> MachineIds = ProdEquipments.stream()
                .map(ProdEquipment::getEquipId)
                .distinct()
                .sorted()
                .collect(Collectors.toList());

        List<Machine> machines=new ArrayList<>();

        for (Long id : MachineIds) {
            Machine machine=new Machine();
            machine.setId(id);
            machines.add(machine);
        }
        //节假日
        List<MesHoliday> holidays=  _MesHolidayService.list();

        LambdaQueryWrapper<ProdEquipSpecialCal> ProdEquipSpecialCalWrapper = new LambdaQueryWrapper<>();
        ProdEquipSpecialCalWrapper.eq(ProdEquipSpecialCal::getSceneId, SceneId);

        List<PlanResource> PlanResources=  _PlanResourceService.lambdaQuery()
                .eq(PlanResource::getIsdeleted,0)
                .list();



        List<ProdEquipSpecialCal> ProdEquipSpecialCals=  _prodEquipSpecialCalService.list(ProdEquipSpecialCalWrapper);

        List<MesShiftWorkSched> MesShiftWorkScheds=  _MesShiftWorkSchedService.lambdaQuery()
                .eq(MesShiftWorkSched::getIsdeleted,0).list();


        if (machines == null) {
            return null;
        }

        for (Machine machine : machines) {
            // 确保维护窗口列表不为null
            if (machine.getMaintenanceWindows() == null) {
                machine.setMaintenanceWindows(new ArrayList<>());
            }
            List<ProdEquipSpecialCal> machineProdEquipSpecialCals = ProdEquipSpecialCals.stream()
                    .filter(t -> t.getEquipId() == machine.getId()&&t.getReferenceType()==1)
                    .collect(Collectors.toList());
            List<Shift> shifts1=new ArrayList<>();
            for (ProdEquipSpecialCal machineProdEquipSpecialCal : machineProdEquipSpecialCals) {

                List<MesShiftWorkSched> ShiftWorkScheds = MesShiftWorkScheds.stream()
                        .filter(t -> (long) t.getWeekWorkSchedId() == machineProdEquipSpecialCal.getReferenceId())
                        .collect(Collectors.toList());
                List<Shift> Shifts = mergeShiftData(ShiftWorkScheds);
                for (Shift shift : Shifts) {

                    shift.setMachineId(machine.getId());
                    shift.setStartDate(machineProdEquipSpecialCal.getStartDate());
                    shift.setEndDate(machineProdEquipSpecialCal.getEndDate());
                    shifts1.add(shift);
                }
            }
            List<PlanResource> PlanResources1 = PlanResources.stream()
                    .filter(t -> t.getReferenceId() == machine.getId())
                    .collect(Collectors.toList());
            if(PlanResources1!=null&&PlanResources1.size()>0)
            {
                for (PlanResource PlanResource : PlanResources1) {

                    List<MesShiftWorkSched> ShiftWorkScheds = MesShiftWorkScheds.stream()
                            .filter(t -> (long) t.getWeekWorkSchedId() == PlanResource.getWorkSchedId())
                            .collect(Collectors.toList());
                    List<Shift> Shifts = mergeShiftData(ShiftWorkScheds);
                    for (Shift shift : Shifts) {

                        shift.setMachineId(machine.getId());
                        shift.setStartDate(LocalDateTime.of(2000, 1, 1, 0, 0, 0));
                        shift.setEndDate(LocalDateTime.of(2000, 1, 1, 0, 0, 0));
                        shifts1.add(shift);
                    }
                }

            }

            machine.setShifts(shifts1);

            List<ProdEquipSpecialCal> Holidays = ProdEquipSpecialCals.stream()
                    .filter(t -> t.getEquipId() == machine.getId()&&t.getReferenceType()==2)
                    .collect(Collectors.toList());
            List<Holiday> Holidays1=new ArrayList<>();
            for (ProdEquipSpecialCal machineProdEquipSpecialCal : Holidays) {

                Holiday holiday=new Holiday();
                holiday.setStart(machineProdEquipSpecialCal.getStartDate());
                holiday.setEnd(machineProdEquipSpecialCal.getEndDate());
                Holidays1.add(holiday);
            }
            machine.setHolidays(Holidays1);



        }


        // 4. 初始化机器时间线
        for (Machine machine : machines) {
            MachineTimeline timeline = machineScheduler.getOrCreateTimeline(machine);
            machine.setAvailability(timeline.getSegments());
        }
        return  machines;


    }

    private Map<Integer, Object> InitEntrys(String SceneId,List<ProdEquipment> ProdEquipments,List<ProdLaunchOrder> ProdLaunchOrders)
    {
        Map<Integer, Object> list=new HashMap<>();
        List<ProdProcessExec> ProdProcessExecs=  _prodProcessExecService.lambdaQuery()
                .eq(ProdProcessExec::getSceneId,SceneId)
                .list();



        List<ProdOrderProcess> ProdOrderProcesss = _prodOrderProcessService.lambdaQuery()
                .eq(ProdOrderProcess::getSceneId,SceneId)
                .list();

        List<String> soutceExecId = ProdOrderProcesss.stream()
                .map(ProdOrderProcess::getExecId)
                .distinct() // 提取Exec_ID
                .collect(Collectors.toList());

        List<String> targetExecId = ProdOrderProcesss.stream()
                .map(ProdOrderProcess::getTargetExecId)
                .distinct() // 提取TARGET_Exec_ID
                .collect(Collectors.toList());

        List<String> ExecIdNoChild=  ProdProcessExecs.stream()
                .filter(e -> !soutceExecId.contains(e.getExecId())&&!targetExecId.contains(e.getExecId()))  // 过滤条件
                .map(ProdProcessExec::getExecId)
                .distinct()
                .collect(Collectors.toList());

        if(ExecIdNoChild!=null&&ExecIdNoChild.size()>0)
        {
            for (String ExecId : ExecIdNoChild) {
                soutceExecId.add(ExecId);
                targetExecId.add("");
            }
        }


        List<GroupResult> results= IdGroupingWithDualSerial.groupAndOrderIds(soutceExecId,targetExecId);


        List<Entry> entrys=new ArrayList<>();

        for (int i = 0; i < results.size(); i++) {
            GroupResult groupResult = results.get(i);
            List<NodeInfo> nodeInfoList = groupResult.getNodeInfoList();
           // System.out.println("分组" + (i + 1) + "顺序：" + nodeInfoList);
            for (NodeInfo nodeInfo : nodeInfoList) {
//                System.out.printf("原始ID：%s → 全局序号：%d，分组内序号：%d，新父ID列表：%s，新子ID列表：%s%n",
//                        nodeInfo.getOriginalId(),
//                        nodeInfo.getGlobalSerial(),
//                        nodeInfo.getGroupSerial(),
//                        nodeInfo.getNewParentIds().isEmpty() ? "无" : nodeInfo.getNewParentIds(),
//                        nodeInfo.getNewChildIds());

                Entry entry = new Entry();

                entry.setId(nodeInfo.getGlobalSerial());
                entry.setGroupId(i + 1);
                entry.setSequence(nodeInfo.getGroupSerial());
                entry.setExecId(nodeInfo.getOriginalId());

                if(nodeInfo.getNewParentIds()!=null)
                {
                    List<OperationDependency> OperationDependency=new ArrayList<>();
                    for (int id : nodeInfo.getNewParentIds()) {
                        OperationDependency od=new OperationDependency();
                        od.setPrevOperationId(id);
                        OperationDependency.add(od);
                    }
                    entry.setPrevEntryIds(OperationDependency);
                }
                if(nodeInfo.getNewChildIds()!=null)
                {
                    List<OperationDependency> OperationDependency=new ArrayList<>();
                    for (int id : nodeInfo.getNewChildIds()) {
                        OperationDependency od=new OperationDependency();
                        od.setNextOperationId(id);
                        OperationDependency.add(od);
                    }
                    entry.setNextEntryIds(OperationDependency);
                }
                ProdProcessExec op= ProdProcessExecs.stream()
                        .filter(t->t.getExecId().equals(entry.getExecId()))
                                .findFirst().orElse(null);
                if(op!=null)
                {
                    entry.setOrderId(op.getOrderId());
                    entry.setQuantity(op.getPlanQty());
                    entry.setRoutingDetailId(op.getRoutingDetailId());
                    entry.setTaskSeq(op.getTaskSeq());
                    entry.setRoutingDetailName(op.getRoutingDetailName());
                    ProdLaunchOrder order = ProdLaunchOrders.stream()
                            .filter(t -> t.getOrderId().equals(op.getOrderId()))
                            .findFirst().orElse(null);
                    if (order != null) {
                        entry.setProductId(order.getMaterialId());
                    }
                    List<ProdEquipment> Equipments = ProdEquipments.stream()
                            .filter(t -> t.getExecId().equals(op.getExecId()))
                            .collect(Collectors.toList());
                    if (Equipments != null && Equipments.size() > 0) {
                        List<MachineOption> mos = new ArrayList<>();
                        for (ProdEquipment e : Equipments) {
                            MachineOption mo = new MachineOption();
                            mo.setMachineId(e.getEquipId());
                            mo.setProcessingTime(e.getSpeed());
                             mo.setContantTime(op.getConstTime());
                             mo.setSetupTime(op.getChangeLineTime());
                             mo.setTeardownTime(op.getPostprocessingTime());
                             mo.setPreTime(e.getSetupTime());

                            mos.add(mo);
                        }
                        entry.setMachineOptions(mos);
                    }
                }
                entry.setPriority(1);
                entrys.add(entry);
            }
            // 输出每个节点的详细信息

            System.out.println("------------------------");
        }
        list.put(1,entrys);
        list.put(2,results);

        return  list;

    }

    /**
     * 合并重复的ShiftData，将serialNumber收集为列表
     * @param originalList 原始数据列表
     * @return 合并后的MergedShiftData列表
     */
    public static List<Shift> mergeShiftData(List<MesShiftWorkSched> originalList) {
        // 按shiftStart和shiftEnd分组
        Map<String, Shift> groupMap = new HashMap<>();

        for (MesShiftWorkSched data : originalList) {
            // 用shiftStart+shiftEnd作为分组key
            String groupKey = data.getShiftStart().toString() + "_" + data.getShiftEnd().toString();

            if (groupMap.containsKey(groupKey)) {
                // 已存在分组：添加serialNumber到列表
                Shift merged = groupMap.get(groupKey);
                merged.getDays().add(data.getStartWeekDay());
            } else {
                // 新分组：创建MergedShiftData并初始化
                Shift merged = new Shift();

                merged.setStartTime(data.getShiftStart().toLocalTime());
                merged.setEndTime(data.getShiftEnd().toLocalTime());
                merged.setStatus(0);

                // 初始化序号列表
                Set<Integer> serials =new HashSet<>();
                serials.add(data.getStartWeekDay());
                merged.setDays(serials);
                groupMap.put(groupKey, merged);
            }
        }

        // 转换为列表返回
        return new ArrayList<>(groupMap.values());
    }


    public GenVO convertGeneToGenVO(Gene gene, LocalDateTime baseTime) {
        GenVO genVO = new GenVO();
        genVO.setOrderId(String.valueOf(gene.getOrderId()));
        genVO.setOperationId(gene.getOperationId());
        genVO.setEquipId(gene.getMachineId());
        genVO.setQuantity(BigDecimal.valueOf(gene.getBatchSize()));
        genVO.setStartTime(baseTime.plusMinutes(gene.getStartTime()));
        genVO.setEndTime(baseTime.plusMinutes(gene.getEndTime()));
        genVO.setOperationName(""); // 从其他数据源获取
        genVO.setEquipName(""); // 从其他数据源获取
        return genVO;
    }

    // 批量转换
    public List<GenVO> convertGeneListToGenVO(List<Gene> geneList, LocalDateTime baseTime) {
        return geneList.stream()
                .map(gene -> convertGeneToGenVO(gene, baseTime))
                .collect(Collectors.toList());
    }
    
    public List<MachineVO> convertMachineListToVO(List<Machine> machines) {
        return machines.stream()
                .map(this::convertToVO)
                .collect(Collectors.toList());
    }
    
    private MachineVO convertToVO(Machine machine) {
        MachineVO machineVO = new MachineVO();
        machineVO.setId(machine.getId());
        machineVO.setEquipId(String.valueOf(machine.getId()));
        machineVO.setEquipName(machine.getName());
        // 注意：tasks 字段需要在其他地方设置，因为 Machine 类中没有任务信息
        return machineVO;
    }





    public List<Machine> InitCalendarToAllMachines1(String SceneId) {
        // 按设备分组
        List<ProdEquipment> ProdEquipments=  _prodEquipmentService.lambdaQuery()
                .eq(ProdEquipment::getSceneId,SceneId)
                .list();
        List<Long> MachineIds = ProdEquipments.stream()
                .map(ProdEquipment::getEquipId)
                .distinct()
                .sorted()
                .collect(Collectors.toList());

        List<Machine> machines=new ArrayList<>();

        for (Long id : MachineIds) {
            Machine machine=new Machine();
            machine.setId(id);
            machines.add(machine);
        }
        //节假日
        List<MesHoliday> holidays=  _MesHolidayService.list();

        LambdaQueryWrapper<ProdEquipSpecialCal> ProdEquipSpecialCalWrapper = new LambdaQueryWrapper<>();
        ProdEquipSpecialCalWrapper.eq(ProdEquipSpecialCal::getSceneId, SceneId);

        List<PlanResource> PlanResources=  _PlanResourceService.lambdaQuery()
                .eq(PlanResource::getIsdeleted,0)
                .list();



        List<ProdEquipSpecialCal> ProdEquipSpecialCals=  _prodEquipSpecialCalService.list(ProdEquipSpecialCalWrapper);

        List<MesShiftWorkSched> MesShiftWorkScheds=  _MesShiftWorkSchedService.lambdaQuery()
                .eq(MesShiftWorkSched::getIsdeleted,0).list();


        if (machines == null) {
            return null;
        }

        for (Machine machine : machines) {
            // 确保维护窗口列表不为null
            if (machine.getMaintenanceWindows() == null) {
                machine.setMaintenanceWindows(new ArrayList<>());
            }
            List<ProdEquipSpecialCal> machineProdEquipSpecialCals = ProdEquipSpecialCals.stream()
                    .filter(t -> t.getEquipId() == machine.getId()&&t.getReferenceType()==1)
                    .collect(Collectors.toList());
            List<Shift> shifts1=new ArrayList<>();
            for (ProdEquipSpecialCal machineProdEquipSpecialCal : machineProdEquipSpecialCals) {

                List<MesShiftWorkSched> ShiftWorkScheds = MesShiftWorkScheds.stream()
                        .filter(t -> (long) t.getWeekWorkSchedId() == machineProdEquipSpecialCal.getReferenceId())
                        .collect(Collectors.toList());
                List<Shift> Shifts = mergeShiftData(ShiftWorkScheds);
                for (Shift shift : Shifts) {

                    shift.setMachineId(machine.getId());
                    shift.setStartDate(machineProdEquipSpecialCal.getStartDate());
                    shift.setEndDate(machineProdEquipSpecialCal.getEndDate());
                    shifts1.add(shift);
                }
            }





            // 转换为列表返回
            List<Shift> result = new ArrayList<>();
            for (Shift shift : shifts1) {
                // 处理跨天班次（开始时间晚于结束时间的情况，如 7:30 到 3:30）
                if (shift.getEndTime().isBefore(shift.getStartTime())) {
                    // 创建第一天的班次 (开始时间到24:00)
                    Shift firstShift = new Shift();
                    firstShift.setStartTime(shift.getStartTime());
                    firstShift.setEndTime(LocalTime.of(23, 59, 59)); // 23:59:59代替24:00
                    firstShift.setDays(new HashSet<>(shift.getDays()));
                    firstShift.setStatus(shift.getStatus());

                    // 创建第二天的班次 (00:00到结束时间)
                    Shift secondShift = new Shift();
                    secondShift.setStartTime(LocalTime.MIDNIGHT);
                    secondShift.setEndTime(shift.getEndTime());
                    secondShift.setDays(new HashSet<>(shift.getDays()));
                    secondShift.setStatus(shift.getStatus());

                    result.add(firstShift);
                    result.add(secondShift);
                } else {
                    // 正常班次直接添加
                    result.add(shift);
                }
            }
            machine.setShifts(result);


            List<ProdEquipSpecialCal> Holidays = ProdEquipSpecialCals.stream()
                    .filter(t -> t.getEquipId() == machine.getId()&&t.getReferenceType()==2)
                    .collect(Collectors.toList());
            List<Holiday> Holidays1=new ArrayList<>();
            for (ProdEquipSpecialCal machineProdEquipSpecialCal : Holidays) {

                Holiday holiday=new Holiday();
                holiday.setStart(machineProdEquipSpecialCal.getStartDate());
                holiday.setEnd(machineProdEquipSpecialCal.getEndDate());
                Holidays1.add(holiday);
            }
            machine.setHolidays(Holidays1);



        }


        return  machines;


    }





}