package com.aps.entity.basic;


import com.aps.entity.Algorithm.OperationDependency;
import com.aps.entity.RoutingDiscreteParam;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * 作者：佟礼
 * 时间：2025-11-21
 */
@Data
public class Entry {
    public Entry() {
        PrevEntryIds=new ArrayList<OperationDependency>();

    }
    /**
     * 基因编号
     */
    public int id ;
    /**
     * 所属组ID 需要按照前后顺序生产的工单给一组
     */
    public int GroupId ;

    public String OrderId ;

    public String OrderCode ;

    /**
     * 原订单ID
     */
    public String SceneId ;
    private Integer routingId;
    private String routingCode;
    private String routingName;
    /** 部门ID，来自工艺路线 routing_header.department_id，在创建 Entry 时从工艺头带出 */
    private Integer departmentId;
    private Long routingDetailId;
    private Long taskSeq;
    private String routingDetailName;


    private String productId;
    private String productCode;
    private String productName;
    /**
     * 工单ID
     */
    public String ExecId ;

    /**
     * 工单ID
     */
    public String MainId;

    /**
     * 离散参数
     */
    public List<RoutingDiscreteParam> DiscreteParameter ;
    /**
     * 基因编号
     */
    public double Priority=1;
    /**
     * 基因编号
     */
    public Double Quantity;
    /**
     * 工序顺序
     */
    public int Sequence;
    /**
     * 可选设备列表
     */
    private List<MachineOption> MachineOptions ;

    /**
     * 选择的设备
     */
    private Long  SelectMachineID ;

    /**
     * 前工单ID
     */
    public List<OperationDependency> PrevEntryIds ;//前工序

    /**
     * 后工单ID
     */
    public List<OperationDependency> NextEntryIds ;//后工序

    /**
     * 数据状态 1 拆分 2 新建
     */
    public Integer state ;

/**
 * 是否可中断，间缝插针
 */
    public Long IsInterrupt = 1l;

    /**
     * 所需物料
     */
    public List<MaterialRequirement> MaterialRequirements ; // 所需物料
    /**
     * 设备资源组
     */

    public Long  EquipTypeID ;

    /// <summary>
    /// 当前工序依赖的前置工序ID（半成品工序→成品工序）
    /// </summary>
    public List<Integer> DependentOnOrderIds =new ArrayList<>();



    /// <summary>
    /// 关联的成品工序ID（核心：明确该半成品服务于哪个成品工序）
    /// </summary>
    public List<Integer> TargetFinishedOperationId;

    private boolean newCreate = false;

    /// <summary>
    /// 半成品最晚完工时间（即成品工序开始时间-1天）
    /// </summary>
    public LocalDateTime LatestCompletionTime ;


    private String equipTypeName;//资源组名称
    private String equipTypeCode;//资源组编码
    private BigDecimal runtime;//持续时间
    private BigDecimal singleOut;//单件产出
    private double changeLineTime;//换模时间
    private BigDecimal setupTime;//准备时间
    private int teardownTime; // （后处理时间）
    private int preTime; // （前处理时间）
    //常数时间
    private int constTime;
    private String equipCode;//设备编码
    private String equipName;//设备编码


    @Schema(description = "指定开始时间")
    @JsonInclude(JsonInclude.Include.ALWAYS)
    private LocalDateTime designatedStartTime;
}
