package com.aps.entity.common;


import com.aps.entity.ProdEquipment;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

@Configuration
public class EntityConfigConfiguration {
    
    @Bean
    public Map<String, EntityConfig> entityConfigMap() {
        Map<String, EntityConfig> configMap = new HashMap<>();
        
        // ========== 文件实体配置 ==========
        addFileEntity(configMap, "order", "orders");
        addFileEntity(configMap, "entry", "allOperations");
        addFileEntity(configMap, "machine", "InitMachines");
        addFileEntity(configMap, "globaloperationinfo", "globalOpList");
        addFileEntity(configMap, "groupresult", "OperatRel");
        
        // ========== 数据库实体配置 ==========
        // 设备表配置
        addDbEntity(configMap, "prod_equipment", "PROD_EQUIPMENT", ProdEquipment.class);


        
        return configMap;
    }
    
    /**
     * 添加文件实体配置
     */
    private void addFileEntity(Map<String, EntityConfig> configMap, String entityName, String fieldName) {
        EntityConfig config = new EntityConfig();
        config.setEntityName(entityName);
        config.setDataSource(DataSourceType.FILE);
        config.setFieldName(fieldName);
        config.setTableName(null);
        config.setEntityClass(null);
        configMap.put(entityName.toLowerCase(), config);
    }
    
    /**
     * 添加数据库实体配置
     */
    private void addDbEntity(Map<String, EntityConfig> configMap, String entityName, String tableName, Class<?> entityClass) {
        EntityConfig config = new EntityConfig();
        config.setEntityName(entityName);
        config.setDataSource(DataSourceType.DATABASE);
        config.setTableName(tableName);
        config.setEntityClass(entityClass);
        config.setFieldName(null);
        configMap.put(entityName.toLowerCase(), config);
    }
}