package com.aps.entity.basic;
import lombok.Data;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * 物料实体类
 */
@Data
public class Material {
    /**
     * 物料ID
     */
    private int Id;

    /**
     * 物料名称
     */
    private String name;

    /**
     * 当前库存
     */
    private double CurrentStock;

    /**
     * 在途物料（预计到货）
     */
    private List<MaterialSupply> InTransit = new ArrayList<>();

    /**
     * 采购周期
     */
    private int PurchaseLeadTime;


    /**
     * 物料类型
     */
    private MaterialType MaterialType;
    @Override
    public String toString() {
        return "Material{" +
                "id=" + Id +
                ", name='" + name + '\'' +
                ", currentStock=" + CurrentStock +
                ", inTransit=" + InTransit +
                ", purchaseLeadTime=" + PurchaseLeadTime +
                ", type=" + MaterialType +
                '}';
    }
}

